package abstraction;
/**
 * 
 * @author Chiara Coccia, Diego Colarullo
 * @version 1.2 09/03/28
 * @since JDK 1.6
 */


/** 
 * This Class maintains informations about the pair present state and action
 */
public class StateAction {

	private State presentState;
	private Action action;

	/**
	 * Constructor 
	 * @param presentState
	 * @param action
	 */
	public StateAction(State presentState, Action action){
		this.presentState = presentState;
		this.action = action;
	}
		
	/**
	 * @return present state of ActionState
	 */
	public State getPresentState(){
		return this.presentState;
	}
	/**
	 * @return action of ActionState
	 */
	public Action getAction(){
		return this.action;
	}
		
	// override of equals 
	public boolean equals(Object o) {
    	if (o != null && getClass().equals(o.getClass())) {
    		StateAction other = (StateAction)o;
    		return this.presentState.getName().equals(other.getPresentState().getName()) &&  this.action.getName().equals(other.getAction().getName());	
    		}
    	else 
    		return false;
    }
	
	// override of hashCode method to generate a key of HashTable 
	public int hashCode() {
        return (this.presentState.getName()+""+this.action.getName()).hashCode(); 
    } 	
	
	
	// override of toString method to print a ActionState 
	public String toString() {
		return "\n"+presentState +"-"+action;
	}
	
	
}
